<?php
/**
 * Customizer settings for this theme.
 * @since Apka 1.0
 */
if (!class_exists('apka_Customize')) {
    /**
     * CUSTOMIZER SETTINGS
     */
    class apka_Customize
    {

        /**
         * Register customizer options.
         *
         * @param WP_Customize_Manager $wp_customize Theme Customizer object.
         */
        public static function register($wp_customize)
        {
            /* ========================================================================= */
            /*
             * COLORS
             */

            // Primary color
            $wp_customize->add_setting('pr_color', array(
                'default' => '#4d5ce5',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary color', 'apka'),
                'description' => esc_html__('Sets main accent color.', 'apka'),
            )));


            // Primary links hover color
            $wp_customize->add_setting('pr_links_h_color', array(
                'default' => '#131415',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_links_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary hover color', 'apka'),
                'description' => esc_html__('Sets link hover color.', 'apka'),
            )));


            // Primary background color
            $wp_customize->add_setting('pr_bg_color', array(
                'default' => '#f4f3ff',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary background color', 'apka'),
                'description' => esc_html__("Changes accent background color.", 'apka'),
            )));


            // Header background color
            $wp_customize->add_setting('h_bg_color', array(
                'default' => '#f5f4fe',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'h_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Header background color', 'apka'),
                'description' => esc_html__("Changes header background color. If there is no changing of the header color that means the current page uses Elementor builder’s header instead of the site's global, so you need to change the color on the page.", 'apka'),
            )));


            // Footer background color
            $wp_customize->add_setting('f_bg_color', array(
                'default' => '#f5f5f6',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'f_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Footer background color', 'apka'),
                'description' => esc_html__("Changes footer background color.", 'apka'),
            )));


            // Primary dark color
            $wp_customize->add_setting('pr_d_color', array(
                'default' => '#131415',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pr_d_color', array(
                'section' => 'colors',
                'label' => esc_html__('Primary dark color', 'apka'),
                'description' => esc_html__('Sets text color in paragraphs.', 'apka'),
            )));


            // h1 title color
            $wp_customize->add_setting('title_color', array(
                'default' => '#131415',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'title_color', array(
                'section' => 'colors',
                'label' => esc_html__('Title color', 'apka'),
                'description' => esc_html__('Sets color for titles.', 'apka'),
            )));


            // Footer widget title color
            $wp_customize->add_setting('fw_title_color', array(
                'default' => '#131415',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'fw_title_color', array(
                'section' => 'colors',
                'label' => esc_html__('Footer widget title color', 'apka'),
            )));


            // Button background color
            $wp_customize->add_setting('btn_bg_color', array(
                'default' => '#4d5ce5',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Button background color', 'apka'),
            )));


            // Button hover color
            $wp_customize->add_setting('btn_h_color', array(
                'default' => '#131415',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'btn_h_color', array(
                'section' => 'colors',
                'label' => esc_html__('Button hover color', 'apka'),
            )));


            // Text selection background color
            $wp_customize->add_setting('txt_select_bg_color', array(
                'default' => '#e5e6ff',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_hex_color'
            ));

            $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'txt_select_bg_color', array(
                'section' => 'colors',
                'label' => esc_html__('Text selection background color', 'apka'),
                'description' => esc_html__('Changes text selection background color. Try to select text on a page.', 'apka'),
            )));
            

            /* end COLORS */
            /* ========================================================================= */
            /*
             * HEADER
             */

            $wp_customize->add_section('header', array(
                'title' => esc_html__('Header', 'apka')
            ));


            // Enable CTA button in the header
            $wp_customize->add_setting('h_cta_btn_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_btn_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Enable CTA button (call-to-action).', 'apka'),
                'type' => 'checkbox'
            ));


            // Header CTA button link
            $wp_customize->add_setting('h_cta_btn_link', array(
                'default' => esc_html__('/contact-us', 'apka'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_btn_link', array(
                'section' => 'header',
                'label' => esc_html__('CTA button link:', 'apka'),
                'type' => 'text'
            ));


            // Header CTA button text
            $wp_customize->add_setting('h_cta_btn_txt', array(
                'default' => esc_html__('Buy Now', 'apka'),
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('h_cta_btn_txt', array(
                'section' => 'header',
                'label' => esc_html__('CTA button text:', 'apka'),
                'type' => 'text'
            ));


            // Sticky header
            $wp_customize->add_setting('sticky_header_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('sticky_header_switcher', array(
                'section' => 'header',
                'label' => esc_html__('Sticky header', 'apka'),
                'type' => 'checkbox'
            ));


            /* end HEADER */
            /* ========================================================================= */
            /*
             * FOOTER
             */

            $wp_customize->add_section('footer', array(
                'title' => esc_html__('Footer', 'apka')
            ));

            // Switcher for Copyright text
            $wp_customize->add_setting('copyright_text_switcher', array(
                'default' => false,
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('copyright_text_switcher', array(
                'section' => 'footer',
                'label' => esc_html__('Disable "Copyright" text before the year', 'apka'),
                'type' => 'checkbox'
            ));

            // Custom copyright
            $wp_customize->add_setting('copyright_text', array(
                'default' => '',
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('copyright_text', array(
                'section' => 'footer',
                'label' => esc_html__('Custom copyright text.', 'apka'),
                'description' => esc_html__('Leave blank to use default copyright.', 'apka'),
                'type' => 'text'
            ));


            /* end FOOTER */
            /* ========================================================================= */
            /*
             * TWEAKS
             */

            $wp_customize->add_section('tweaks', array(
                'title' => esc_html__('Tweaks', 'apka')
            ));


            // Disable post category meta text
            $wp_customize->add_setting('meta_cat_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_cat_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post category meta text', 'apka'),
                'type' => 'checkbox'
            ));


            // Disable date meta text
            $wp_customize->add_setting('meta_date_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_date_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable date meta text', 'apka'),
                'type' => 'checkbox'
            ));


            // Disable post author meta text
            $wp_customize->add_setting('meta_author_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_author_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post author meta text', 'apka'),
                'type' => 'checkbox'
            ));


            // Disable post comments meta text
            $wp_customize->add_setting('meta_comm_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('meta_comm_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable post comments meta text', 'apka'),
                'type' => 'checkbox'
            ));


            // Disable icon before title
            $wp_customize->add_setting('icon_before_title_switcher', array(
                'default' => false,
                'transport' => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field'
            ));

            $wp_customize->add_control('icon_before_title_switcher', array(
                'section' => 'tweaks',
                'label' => esc_html__('Disable icon before title', 'apka'),
                'type' => 'checkbox'
            ));


            /* end TWEAKS */
            /* ========================================================================= */


            /* -----------------------------*/
            /* end Customize Settings */
            /* -----------------------------*/
        }
    }


    // Setup the Theme Customizer settings and controls.
    add_action('customize_register', array('apka_Customize', 'register'));

}