<?php

/**
 * Global DNS - Common Admin Header
 *
 * @link       thehp.in
 * @since      2.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/admin/partials/common
 */
?>

<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap">
<div class="font-sans border-blue-500 border-t-4 -ml-5">
    <div class="flex items-center justify-between p-5">
        <div class="global-dns-logo">
            <img src="<?php echo $this->plugin_admin_dir() . 'images/logo.png' ?>" alt="Global DNS Logo">
        </div>
        <span class="relative inline-flex items-center">
            <span class="animate-ping bg-yellow-600 absolute h-3 w-3 top-0 left-0 -mt-1 -ml-1 rounded-full"></span>
            <a class="bg-yellow-300 rounded px-3 py-2" href="https://shop.thehp.in/product/global-dns-servers-pack/" target="_blank" rel="noopener noreferrer">
                <?php _e('Buy Premium Servers') ?>
            </a>
        </span>
    </div>
    <div id="global-dns-menu" class="flex items-center px-5 bg-white space-x-10 text-sm">
        <a class="py-5 border-white border-b-2 hover:border-gray-700 focus:shadow-none" href="<?php echo admin_url('admin.php?page=' . $this->plugin_name) ?>"><?php _e('Servers') ?></a>
        <a class="py-5 border-white border-b-2 hover:border-gray-700 focus:shadow-none" href="<?php echo admin_url('admin.php?page=' . $this->plugin_name . '-settings') ?>"><?php _e('Settings') ?></a>
        <a class="py-5 border-white border-b-2 hover:border-gray-700 focus:shadow-none" href="<?php echo admin_url('admin.php?page=' . $this->plugin_name . '-instructions') ?>"><?php _e('Instructions') ?></a>
    </div>
</div>