<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://thehp.in
 * @since      1.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/admin/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<main class="font-sans space-y-10 my-8 pr-5">
    <div class="space-y-5">
        <div class="section-title">
            <h2 class="text-xl font-bold"><?php _e('Shortcodes') ?></h2>
            <p class="text-gray-500"><?php _e('Below are the shortcodes that you will need to enter in your page.') ?></p>
        </div>
        <div class="grid grid-cols-1 2xl:grid-cols-2 gap-5">
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('DNS Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 md:grid-cols-3 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Input Form') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_input]">
                            <code class="block text-xl font-bold bg-white">[global_dns_input]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Servers List') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_list]">
                            <code class="block text-xl font-bold bg-white">[global_dns_list]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('World Map') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_map]">
                            <code class="block text-xl font-bold bg-white">[global_dns_map]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('WHOIS Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Input Form') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_whois_input]">
                            <code class="block text-xl font-bold bg-white">[global_dns_whois_input]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('WHOIS Data') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_whois]">
                            <code class="block text-xl font-bold bg-white">[global_dns_whois]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('IP Lookup Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Input Form') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_ip_lookup_input]">
                            <code class="block text-xl font-bold bg-white">[global_dns_ip_lookup_input]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('IP Lookup Data') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_ip_lookup]">
                            <code class="block text-xl font-bold bg-white">[global_dns_ip_lookup]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('Blacklist Checker Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Input Form') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_blacklist_input]">
                            <code class="block text-xl font-bold bg-white">[global_dns_blacklist_input]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Blacklist Results') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_blacklist]">
                            <code class="block text-xl font-bold bg-white">[global_dns_blacklist]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('DMARC Checker Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Input Form') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_dmarc_input]">
                            <code class="block text-xl font-bold bg-white">[global_dns_dmarc_input]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('DMARC Results') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_dmarc]">
                            <code class="block text-xl font-bold bg-white">[global_dns_dmarc]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('Email Headers Extractor Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Input Form') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_email_headers_input]">
                            <code class="block text-xl font-bold bg-white">[global_dns_email_headers_input]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('Email Headers List') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_dns_email_headers]">
                            <code class="block text-xl font-bold bg-white">[global_dns_email_headers]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-4 border-dashed p-5">
                <div class="section-title">
                    <h3 class="text-base font-semibold text-center mb-3 text-gray-500"><?php _e('Additional Shortcodes') ?></h3>
                </div>
                <div class="shortcodes grid grid-cols-1 gap-5">
                    <div class="bg-white p-4 rounded-lg shadow text-center space-y-5">
                        <h4 class="text-base font-semibold"><?php _e('User IP') ?></h4>
                        <div class="copy cursor-pointer" data-data="[global_user_ip]">
                            <code class="block text-xl font-bold bg-white">[global_user_ip]</code>
                            <small class="mt-2">
                                <?php _e('Click to Copy') ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="space-y-5">
        <div class="section-title">
            <h3 class="text-lg font-semibold"><?php _e('Configure Shortcodes') ?></h3>
            <p class="text-gray-500"><?php _e('Below are the various configuration options for Global DNS Shortcodes') ?></p>
        </div>
        <div>
            <h4 class="text-sm font-semibold mb-3"><?php _e('DNS, WHOIS, IP Lookup, Blacklist Checker, DMARC Checker & Email Headers Extractor Input Form - Shortcode') ?></h4>
            <table class="table-auto" cellpadding="10">
                <thead>
                    <tr class="border border-gray-600">
                        <th class="text-left"><?php _e('Parameter') ?></th>
                        <th class="text-left"><?php _e('Value') ?></th>
                        <th class="text-left"><?php _e('Details') ?></th>
                        <th class="text-left"><?php _e('Example') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="border border-gray-400">
                        <td>btn-text</td>
                        <td><?php _e('Button Text') ?></td>
                        <td><?php _e('This will set the text of the submit button') ?></td>
                        <td>[global_dns_input btn-text=Search]</td>
                    </tr>
                    <tr class="border border-gray-400">
                        <td>btn-bg-color</td>
                        <td><?php _e('Color HEX Code') ?></td>
                        <td><?php _e('This will be the background color of the button in the input form') ?></td>
                        <td>[global_dns_input btn-bg-color=#c65e32]</td>
                    </tr>
                    <tr class="border border-gray-400">
                        <td>btn-text-color</td>
                        <td><?php _e('Color HEX Code') ?></td>
                        <td><?php _e('This will be the text color of the button in the input form') ?></td>
                        <td>[global_dns_input btn-text-color=#eeeeee]</td>
                    </tr>
                    <tr class="border border-gray-400">
                        <td>icon-bg-color</td>
                        <td><?php _e('Color HEX Code') ?></td>
                        <td><?php _e('This will be the background color of the icon in the input form') ?></td>
                        <td>[global_dns_input icon-bg-color=#333333]</td>
                    </tr>
                    <tr class="border border-gray-400">
                        <td>icon-text-color</td>
                        <td><?php _e('Color HEX Code') ?></td>
                        <td><?php _e('This will be the text color of the icon in the input form') ?></td>
                        <td>[global_dns_input icon-text-color=#ffffff]</td>
                    </tr>
                    <tr class="border border-gray-400">
                        <td>default-type</td>
                        <td><?php _e('Default Type') ?></td>
                        <td><?php _e('This will set the default type pre-selected in the input form') ?></td>
                        <td>[global_dns_input default-type=MX]</td>
                    </tr>
                    <tr class="border border-gray-400">
                        <td>input-placeholder</td>
                        <td><?php _e('Input Field Placeholder') ?></td>
                        <td><?php _e('This will set the placeholder for the input field') ?></td>
                        <td>[global_dns_input input-placeholder=www.google.com]</td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div>
            <h4 class="text-sm font-semibold mb-3"><?php _e('Server List - Shortcode') ?></h4>
            <table class="table-auto" cellpadding="10">
                <thead>
                    <tr class="border border-gray-600">
                        <th class="text-left"><?php _e('Parameter') ?></th>
                        <th class="text-left"><?php _e('Details') ?></th>
                        <th class="text-left"><?php _e('Example') ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="border border-gray-400">
                        <td>no_flag</td>
                        <td><?php _e('This parameter will hide the flag from the server list') ?></td>
                        <td>[global_dns_list no_flag]</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="space-y-5">
        <div class="section-title">
            <h2 class="text-xl font-bold"><?php _e('Video Tutorial') ?></h2>
            <p class="text-gray-500"><?php _e('If you\'re struggling to setup Global DNS, check out this video.') ?></p>
        </div>
        <iframe width="auto" height="315" style="width: 560px; max-width: 100%;" src="https://www.youtube.com/embed/7HsoSuIsB_U" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    </div>
</main>