<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://thehp.in
 * @since      1.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/admin/partials
 */

$settings = get_option($this->plugin_name . "-settings");
if (!is_array($settings)) {
    $settings = get_option($this->plugin_name);
    if (is_array($settings)) {
        $settings['enable_dark_mode'] = $settings['dark_mode'];
    }
}
$default = array(
    'primary_color' => '#2373be',
    'enable_dark_mode' => true,
    'enable_expected_button' => true,
    'dark_mode_color' => '#111111',
    'secret' => str_shuffle('abcdefghiiqnwd'),
    'timeout' => '5',
    'custom_css' => '',
    'blacklist_servers' => ["dyna.spamrats.com", "all.s5h.net", "b.barracudacentral.org", "spam.spamrats.com", "zen.spamhaus.org", "dnsbl.dronebl.org", "spam.rbl.blockedservers.com", "rbl.interserver.net", "spamsources.fabel.dk", "bl.scientificspam.net", "dnsbl.zapbl.net", "bl.rbl.scrolloutf1.com", "dnsbl.kempt.net", "mail-abuse.com", "bl.score.senderscore.com", "exploit.mail.abusix.zone", "new.spam.dnsbl.sorbs.net", "block.dnsbl.sorbs.net", "bl.spamcop.net", "black.mail.abusix.zone", "multi.surbl.org", "escalations.dnsbl.sorbs.net", "zombie.dnsbl.sorbs.net", "dnsbl.tornevall.org", "bl.nordspam.com", "fnrbl.fast.net", "talosintelligence.com", "truncate.gbudb.net", "0spam.fusionzero.com", "bl.nosolicitado.org"],
);
if (!is_array($settings)) {
    $settings = [];
}
foreach ($default as $key => $value) {
    if (!isset($settings[$key])) {
        $settings[$key] = $value;
    }
}
settings_errors();
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<main class="font-sans space-y-10 my-8 pr-5">
    <div>
        <div class="section-title">
            <h2 class="text-xl font-bold"><?php _e('Manage Options') ?></h2>
            <p class="text-gray-500"><?php _e('You can tweak certain settings related to Global DNS here.') ?></p>
        </div>
        <form action="options.php" method="post">
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="primary_color"><?php _e('Primary Color') ?></label>
                <div>
                    <input type="color" class="border-0 shadow-none" name="primary_color" id="primary_color" value="<?php esc_attr_e($settings['primary_color']) ?>">
                    <p><?php _e('Primary color will be used on map and on the button for Global DNS Form and WHOIS Form.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="enable_dark_mode"><?php _e('Enable Dark Mode') ?></label>
                <?php  ?>
                <div>
                    <input type="checkbox" name="enable_dark_mode" id="enable_dark_mode" <?php esc_attr_e($settings['enable_dark_mode'] === 'on' ? 'checked' : '') ?>>
                    <p><?php _e('It sets all the light colors to darker shades.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="enable_expected_button"><?php _e('Enable Expected Button') ?></label>
                <?php  ?>
                <div>
                    <input type="checkbox" name="enable_expected_button" id="enable_expected_button" <?php esc_attr_e($settings['enable_expected_button'] === 'on' ? 'checked' : '') ?>>
                    <p><?php _e('It allows user to add a expected value and checks all the results against that value.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="dark_mode_color"><?php _e('Dark Mode Color') ?></label>
                <div>
                    <input type="color" class="border-0 shadow-none" name="dark_mode_color" id="dark_mode_color" value="<?php esc_attr_e($settings['dark_mode_color']) ?>">
                    <p><?php _e('Dark mode color will be instead of primary color when dark mode is enabled.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="secret"><?php _e('Secret') ?></label>
                <div>
                    <input type="text" class="text-sm mb-1" name="secret" id="secret" value="<?php esc_attr_e($settings['secret']) ?>">
                    <p><?php _e('This is to authenticate your site with different servers.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="timeout"><?php _e('Tiemout') ?></label>
                <div>
                    <div class="mt-1 flex rounded-md mb-1 w-32">
                        <input type="text" class="text-sm flex-1 rounded-none rounded-l-md" name="timeout" id="timeout" value="<?php esc_attr_e($settings['timeout']) ?>">
                        <span class="inline-flex items-center rounded-r-sm bg-gray-600 px-3 text-sm text-white"><?php _e('Seconds') ?></span>
                    </div>
                    <p><?php _e('DNS and WHOIS request will get timeout (aka cancelled) once above seconds are passed.') ?></p>
                    <p><?php _e('Type 0 for no limit.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="custom_css"><?php _e('Custom CSS') ?></label>
                <div>
                    <textarea class="text-sm mb-1 rounded" cols="50" rows="4" name="custom_css" id="custom_css" placeholder="body { color: gray }"><?php _e($settings['custom_css']) ?></textarea>
                    <p><?php _e('For advance users to modify Global DNS frontend UI.') ?></p>
                </div>
            </div>
            <div class="flex flex-col md:flex-row gap-5 my-10">
                <label class="w-60 text-sm" for="blacklist_servers"><?php _e('Blacklist Servers') ?></label>
                <div>
                    <p><?php _e('Manage Blacklist Servers for Blacklist Checker.') ?></p>
                    <div class="blacklist-servers">
                        <?php foreach ($settings['blacklist_servers'] as $server) { ?>
                            <div>
                                <input type="text" class="text-sm" name="blacklist_servers[]" value="<?php esc_attr_e($server) ?>">
                                <button type="button">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" fill="currentColor" class="w-4 h-4">
                                        <path fill-rule="evenodd" d="M5 3.25V4H2.75a.75.75 0 0 0 0 1.5h.3l.815 8.15A1.5 1.5 0 0 0 5.357 15h5.285a1.5 1.5 0 0 0 1.493-1.35l.815-8.15h.3a.75.75 0 0 0 0-1.5H11v-.75A2.25 2.25 0 0 0 8.75 1h-1.5A2.25 2.25 0 0 0 5 3.25Zm2.25-.75a.75.75 0 0 0-.75.75V4h3v-.75a.75.75 0 0 0-.75-.75h-1.5ZM6.05 6a.75.75 0 0 1 .787.713l.275 5.5a.75.75 0 0 1-1.498.075l-.275-5.5A.75.75 0 0 1 6.05 6Zm3.9 0a.75.75 0 0 1 .712.787l-.275 5.5a.75.75 0 0 1-1.498-.075l.275-5.5a.75.75 0 0 1 .786-.711Z" clip-rule="evenodd" />
                                    </svg>
                                </button>
                            </div>
                        <?php } ?>
                    </div>
                    <button type="button" id="blacklist-add-server" class="bg-gray-800 text-white rounded px-2 py-1 mt-5 text-xs">
                        <?php _e('Add Server') ?>
                    </button>
                </div>
            </div>
            <?php
            settings_fields($this->plugin_name);
            do_settings_sections($this->plugin_name);
            ?>
            <button type="submit" name="settings" id="settings" class="bg-blue-600 text-white rounded px-3 py-2 mt-5 flex items-center gap-3">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                </svg>
                <?php _e('Save Settings') ?>
            </button>
        </form>
    </div>
</main>