<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://thehp.in
 * @since      1.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Global_Dns
 * @subpackage Global_Dns/includes
 */
class Global_Dns_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		$role = get_role('administrator');
		$role->remove_cap('aio_contact');
	}
}
