<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       thehp.in
 * @since      2.9.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/public/partials/email_headers
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php
echo "<style>";
if (isset($attr['btn-bg-color'])) {
    echo ".global_dns_email_headers_input input[type=submit] { background: " . $attr['btn-bg-color'] . " !important; border-color: " . $attr['btn-bg-color'] . " !important; }";
}
if (isset($attr['btn-text-color'])) {
    echo ".global_dns_email_headers_input input[type=submit] { color: " . $attr['btn-text-color'] . " !important; }";
}
echo "</style>";
?>
<div class="global_dns_email_headers_input">
    <form method="POST" id="global-dns-email-headers-form">
        <div>
            <textarea name="global-dns-email-headers-input" id="global-dns-email-headers-input" placeholder="<?php esc_attr_e((isset($attr['input-placeholder'])) ? $attr['input-placeholder'] : 'Your email headers here', $this->plugin_name) ?>" required></textarea>
            <input type="submit" value="<?php esc_attr_e((isset($attr['btn-text'])) ? $attr['btn-text'] : 'Extract', $this->plugin_name) ?>">
        </div>
    </form>
</div>
<div class="global_dns d-none">
    <div id="options"><?php esc_html_e(json_encode($settings)); ?></div>
    <div id="nonce"><?php esc_html_e(wp_create_nonce('wp_rest')); ?></div>
</div>