<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       thehp.in
 * @since      1.0.0
 *
 * @package    Global_Dns
 * @subpackage Global_Dns/public/partials
 */

 /**
  * Status tags : checked, cancel, clock
  */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<?php 
if(!is_array($servers)) {
    $servers = array();
}
$show_flag = true;
if(isset($attr[0]) && $attr[0] == "no_flag") {
    $show_flag = false;
}
?>
<div class="global_dns_list">
    <ul>
        <?php for( $i = 0; $i < count($servers); $i++ ) { ?>
        <li id="server-<?php esc_html_e( $i ) ?>">
            <div class="data">
                <?php if($show_flag) { ?>
                <span class="flag"><img width="16px" src="<?php esc_html_e( $pluginurl ) ?>images/flags/<?php esc_html_e(strtolower( $servers[$i]['country'] )) ?>.svg"></span>
                <?php } ?>
                <span class="name"><?php esc_html_e( $servers[$i]['name'] ) ?></span>
                <span class="result"></span>
                <span class="status">
                    <img src="">
                </span>
            </div>
            <?php if(isset($servers[$i]['meta'])) { ?>
            <div class="meta">
                <?php esc_html_e( $servers[$i]['meta'] ) ?>
            </div>
            <?php } ?>
        </li>
        <?php } ?>
    </ul>
</div>